/* This file defines the functions for the SudokuSolution class.
 * Date       User              Note
 * 2009-11-05 Eric Oulashin     Created
 */


#include "SudokuSolution.h"

SudokuSolution::SudokuSolution()
{
	for (int row = 0; row < 9; ++row)
	{
		for (int col = 0; col < 9; ++col)
			mPuzzle[row][col] = 0;
	}
}

SudokuSolution::~SudokuSolution()
{
}

void SudokuSolution::SetValue(int pRow, int pCol, int pValue)
{
	// Make sure pRow and pCol are valid before setting the mPuzzle value.
	if ((pRow >= 0) && (pRow < 9) && (pCol >= 0) && (pCol < 9))
		mPuzzle[pRow][pCol] = pValue;
}

int SudokuSolution::GetValue(int pRow, int pCol) const
{
	if ((pRow >= 0) && (pRow < 9) && (pCol >= 0) && (pCol < 9))
		return (mPuzzle[pRow][pCol]);
	else
		return -1;
}